# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 2
# Experiment: PMxPM, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR2_strategy.txt
# LLM Suggested Fallback: C

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR2(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:  # Round 1
        return "C"
    
    # Check for hardcoded strategies in opponent's code
    always_defect = "return 'D'" in opponent_program_code or "always defect" in opponent_program_code.lower()
    always_cooperate = "return 'C'" in opponent_program_code or "always cooperate" in opponent_program_code.lower()
    
    if always_defect:
        return "D"
    if always_cooperate:
        return "D"  # Exploit always-cooperate
    
    # If opponent has defected at least once, mirror their last move (Tit-for-Tat)
    if "D" in opp_history:
        return opp_history[-1]
    
    # Default to cooperation if opponent has always cooperated
    return "C"